%define version 0.1.3

Summary:	Firewall modules that can be used in an existing firewall
Name:		firebricks
Version:	%{version}
Release:	0
Copyright:	GPL
Group:		Networking/Admin
Source:		http://www.stearns.org/firebricks/firebricks-%{version}.tar.gz
URL:		http://www.stearns.org/firebricks/
Vendor:		William Stearns
Packager:	William Stearns <wstearns@pobox.com>
BuildRoot:	/var/tmp/firebricks-root
Buildarch:	noarch

%description

Firebricks provides a collection of independent firewall modules.  These
can be used to create a complete firewall, or can be individually
inserted into an existing firewall.

%prep
%setup

%build

%install
if [ "$RPM_BUILD_ROOT" = "/var/tmp/firebricks-root" ]; then
	rm -rf $RPM_BUILD_ROOT
	#mkdir -p $RPM_BUILD_ROOT/usr/doc/samlib-%{version}
	#mkdir -p $RPM_BUILD_ROOT/usr/lib/samlib
	make DESTDIR=$RPM_BUILD_ROOT install
else
	echo Invalid Buildroot
	exit 1
fi
	

%clean
if [ "$RPM_BUILD_ROOT" = "/var/tmp/firebricks-root" ]; then
	rm -rf $RPM_BUILD_ROOT
else
	echo Invalid Buildroot
	exit 1
fi

%files
%attr(750,root,root)	%dir			/etc/firebricks
%attr(640,root,root)	%config(noreplace)	/etc/firebricks/blockfwdports.conf
%attr(640,root,root)	%config(noreplace)	/etc/firebricks/firebricks.conf
%attr(755,root,root)				/etc/init.d/firebricks
%attr(750,root,root)	%dir			/usr/lib/firebricks/
%attr(755,root,root)				/usr/lib/firebricks/address
%attr(755,root,root)				/usr/lib/firebricks/banfor30
%attr(755,root,root)				/usr/lib/firebricks/blockfwdports
%attr(755,root,root)				/usr/lib/firebricks/bogons
%attr(755,root,root)				/usr/lib/firebricks/catchmapper
%attr(755,root,root)				/usr/lib/firebricks/catchmapreply
%attr(755,root,root)				/usr/lib/firebricks/checkbans
%attr(755,root,root)				/usr/lib/firebricks/established
%attr(755,root,root)				/usr/lib/firebricks/firebricks-template
%attr(755,root,root)				/usr/lib/firebricks/firebrickslib
%attr(755,root,root)				/usr/lib/firebricks/histogram
%attr(755,root,root)				/usr/lib/firebricks/icmpchk
%attr(755,root,root)				/usr/lib/firebricks/icmpfwdchk
%attr(755,root,root)				/usr/lib/firebricks/identreject
%attr(755,root,root)				/usr/lib/firebricks/ipopts
%attr(755,root,root)				/usr/lib/firebricks/kernel
%attr(755,root,root)				/usr/lib/firebricks/local-forward-accept
%attr(755,root,root)				/usr/lib/firebricks/local-input-accept
%attr(755,root,root)				/usr/lib/firebricks/local-output-accept
%attr(755,root,root)				/usr/lib/firebricks/lockdown
%attr(755,root,root)				/usr/lib/firebricks/mapssh
%attr(755,root,root)				/usr/lib/firebricks/pasvmap
%attr(755,root,root)				/usr/lib/firebricks/plength
%attr(755,root,root)				/usr/lib/firebricks/punishmapper
%attr(755,root,root)				/usr/lib/firebricks/sample-script
%attr(755,root,root)				/usr/lib/firebricks/scrutinize
%attr(755,root,root)				/usr/lib/firebricks/scrutinizedst
%attr(755,root,root)				/usr/lib/firebricks/scrutinizesrc
%attr(755,root,root)				/usr/lib/firebricks/tcpchk
%attr(755,root,root)				/usr/lib/firebricks/udpchk
%attr(750,root,root)	%dir			/var/lib/firebricks/
%attr(640,root,root)	%config			/var/lib/firebricks/bogon-hosts
%attr(640,root,root)	%config			/var/lib/firebricks/bogon-bn-agg.txt
%doc COPYING README.bricksummary.html README.firebricks.html firebricks.txt quickstart.txt

