#ifndef BASE_BUFFER_H
#define BASE_BUFFER_H

void bufferXor(uint8 *dstbuffer, uint8 *srcbuffer, size_t length);
void bufferSwap(uint8 *dstbuffer, uint8 *srcbuffer, size_t length);
void bufferSwap3(uint8 *dstbuffer, uint8 *srcbuffer, uint8 *tmpbuffer, size_t length);
void bufferReverse(uint8 *buffer, size_t length);
void bufferInc(uint8 *dstbuffer, size_t length);
void bufferDec(uint8 *dstbuffer, size_t length);

void bufferSetBEUInt(uint8 *dstbuffer, uint64 value, size_t length);
uint64 bufferGetBEUInt(uint8 *dstbuffer, size_t length);
void bufferSetLEUInt(uint8 *dstbuffer, uint64 value, size_t length);
uint64 bufferGetLEUInt(uint8 *dstbuffer, size_t length);

void bufferSetBEInt(uint8 *dstbuffer, int64 value, size_t length);
int64 bufferGetBEInt(uint8 *dstbuffer, size_t length);
void bufferSetLEInt(uint8 *dstbuffer, int64 value, size_t length);
int64 bufferGetLEInt(uint8 *dstbuffer, size_t length);

#endif //BASE_BUFFER_H

