//
//logger.c
//
//Provides functions for logging.
//
//
//-UserX 2001/11/02
//todo: better detection of logfilename changes

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "base/logger.h"
#include "base/mem.h"
#include "base/str.h"


int atexiton = 0;
int verbosity = LOG_NORMAL;

char defaultlogfilename[] = DEFAULT_LOGFILE;
char *logfilename = NULL;

FILE *logfile = NULL;

int logpossible = 1;

int quietconsole = 0;


//closes the log file
void exitLog(void){
	if(logfile == NULL) {
		return;
	}
	fclose(logfile);
	logfile = NULL;
}

//opens the log file and adds a function to atexit (if it has not done so yet)
//if the log file is already it will close it then open it again.
void initLog(void){
	if(!atexiton) {
		atexit(exitLog);
		atexiton = -1;
	}
	if(logfile != NULL) {
		exitLog();
	}
	if(logpossible == 0) {
		return;
	}
	if(isStringBlank(logfilename)) {
		logfile = fopen(defaultlogfilename, "a");
	} else {
		logfile = fopen(logfilename, "a");
	}
	if(logfile == NULL) {
		logpossible = 0;
		LOGERROR("Unable to open logfile!"); //todo: include the actual logfile name
		return;
	}
	logmsgraw("----------------------------------------------------------------------");
	LOGERROR(stringJoin("Logging at verbosity:", intToString(verbosity)));
	

}

void setVerbosity(int v){
	verbosity = v;
}


//sets the filename to log to.
//no validation of the file name is performed.
void setLogFileName(char *filename) {
	logpossible = 1;
	stringFree(logfilename);
	if(filename == NULL || strlen(filename) == 0) {
		logfilename = NULL;
	} else {
		logfilename = stringCopy(filename);
	}

	if(logfile != NULL) {//if there is a log file open close it and reopen it
		initLog();
	}
}

//log a msg without any timestamping or verbosity checking
void logmsgraw(char *message) {
	if(message == NULL) {
		logmsgraw("NULL passed to logmsgraw.");
		return;
	}

	if(logfile == NULL) {
		initLog();
	}

				
	if(logfile != NULL) {
		fprintf(logfile, "%s\n", message);
		fflush(logfile);
	}
	if(!quietconsole) {
		printf("%s\n", message);
	}
}

//will only write to the log file if it is already open
void logmsgsafe(char *message) {
	if(message == NULL) {
		return;
	}

	if(logfile == NULL) {
		return;
	}

				
	if(logfile != NULL) {
		fprintf(logfile, "%s\n", message);
		fflush(logfile);
	}
	printf("%s\n", message);
}


//log a message with a timestamp.
void logmsg(int verblevel, char *message){
	char *msg;

	if(message == NULL) {
		logmsg(1, "NULL passed to logmsg.");
		return;
	}

	if(verblevel > verbosity) { //return if the verbosity of the message is too high to log.
		return;
	}

	msg = stringAppend3("[", stringDateTime(time(NULL)), "]:");
	msg = stringAppend(msg, message);

	logmsgraw(msg);

	stringFree(msg);
}

//logmsg except message is released via stringFree
void logstring(int verblevel, char *message) {
	logmsg(verblevel, message);
	stringFree(message);
}

