#ifndef BASE_STR_H
#define BASE_STR_H

#include <time.h>
#include "misc/compat.h"

char *stringMake(int length);
char *stringResize(char *dstbuffer, int length);
void stringFree(char *dstbuffer);
char *stringBlank(void);
char *stringCopy(char *srcbuffer);
char *stringReplace(char *dstbuffer, char *srcbuffer);
char *stringCopyPart(char *srcbuffer, int start, int length);
char *stringCopyIfForeign(char *srcbuffer);
char *stringAppend(char *dstbuffer, char *srcbuffer);
char *stringAppend2(char *srcbuffer, char *dstbuffer);
char *stringAppend3(char *src1buffer, char *dstbuffer, char *src2buffer);
char *stringJoin(char *dstbuffer, char *srcbuffer);
char *stringJoinMany(char *srcbuffer, ...);
char *stringCopyMany(char *srcbuffer, ...);

int isStringBlank(char *srcbuffer);

char *intToString(int i);
char *intToStringPadded(unsigned int i, char c, int l);
char *intToHexString(int v);
char *bufferToHexString(uint8 *buf, int length);
char *ptrToString(void *p);
char *stringDateTime(time_t datetime);


char *stringTrim(char *dstbuffer, char *what);
char *stringSplit(char *srcbuffer, char *split);


char intToHexChar(int v);

int stringCaseCompare(char *buffer1, char *buffer2);
int stringCompare(char *buffer1, char *buffer2);
int stringLength(char *buffer);
char *stringToUpper(char *buffer);
char *stringToLower(char *buffer);

#endif //BASE_STR_H
