#ifndef CRYPT_BLOWFISH_H
#define CRYPT_BLOWFISH_H
/*
 * Author     :  Paul Kocher
 * E-mail     :  pck@netcom.com
 * Date       :  1997
 * Description:  C implementation of the Blowfish algorithm.
 */
//addition of BlowfishContext typedef and BLANKBLOWFISHCONTEXT -UserX 2001/11/29
//addition of #ifdef include guards -UserX 2002/06/08

#define MAXKEYBYTES 56          /* 448 bits */

#define BLOWFISH_BLOCK_LENGTH 8


typedef struct {

  unsigned long P[16 + 2];

  unsigned long S[4][256];

} BLOWFISH_CTX;


typedef BLOWFISH_CTX BlowfishContext;


void Blowfish_Init(BLOWFISH_CTX *ctx, unsigned char *key, int keyLen);

void Blowfish_Encrypt(BLOWFISH_CTX *ctx, unsigned long *xl, unsigned long
*xr);

void Blowfish_Decrypt(BLOWFISH_CTX *ctx, unsigned long *xl, unsigned long
*xr);

int Blowfish_Test(BLOWFISH_CTX *ctx);       /* 0=ok, -1=bad */





#endif //CRYPT_BLOWFISH_H
