#ifndef CRYPT_DH_H
#define CRYPT_DH_H

#include "base/bignum.h"


#define DH_GENERATOR_BASE 2



int dhCheckPrime(int bitlength);
int dhGetPrimeLength(int exponentlength);
int dhGetExponentLength(int bitlength);
BigNum *dhGetPrime(int bitlength);
BigNum *dhGeneratePrivKey(int bitlength);
BigNum *dhGeneratePubKey(int bitlength, BigNum *PrivKey);
BigNum *dhGenerateSharedKey(int bitlength, BigNum *PrivKey, BigNum *RemotePubKey);

#endif //CRYPT_DH_H
