#ifndef CRYPT_RANDOM_H
#define CRYPT_RANDOM_H

#include "base/dblock.h"


#define FAST_THRESHOLD 100
#define SLOW_THRESHOLD 160

#define RANDOM_SEED_SIZE 256


void randomAddEntropy(int v, int bits);
void randomAddEntropyBuffer(uint8 *buffer, int length, int bits);
void randomAddEntropyClock(int bits);

void randomInit(void);
unsigned int randomint(unsigned int i);
DataBlock *randomDBlock(int length);
void randomBuffer(char *dstbuffer, int length);


char *randomGetSeedFilename(void);
void randomSetSeedFilename(char *filename);
void randomReadSeed(void);
void randomWriteSeed(void);
void randomFastPoolReseed(void);
void randomSlowPoolReseed(void);
void randomReseedDecide(void);

#define DEFAULT_RANDOMSEEDFILENAME "@seed.rnd"
extern char *randomseedfilename;
extern int randomentropyneeded;

#endif //CRYPT_RANDOM_H
