#ifndef NET_NODESERV_H
#define NET_NODESERV_H

#include "net/noderef.h"

#define DEFAULT_NODEREFFILENAME "@node.ref"
#define DEFAULT_LISTENFILENAME "@listen.ref"
//todo: take these out of the global name space
extern char *nodereffilename;
extern char *listenreffilename;

#define DEFAULT_NETWORKNAME "iip"
#define DEFAULT_NETWORKVERSION "1.1rc2"
extern char *networkname;
extern char *networkversion;

extern int noderefreload;

NodeRef *nodeservPickNode(void);
NodeRef *nodeservPickNextNode(NodeRef *nr);
int nodeservTotalNodeRefs(void);

void nodeservAddNodeRefFile(char *filename);

void nodeservSetNodeRefFile(char *filename);
void nodeservReadNodeRefFile(void);
void nodeservClearNodeRefs(void);

void nodeservAddListenRefFile(char *filename);
void nodeservSetListenRefFile(char *filename);
void nodeservReadListenRefFile(void);
void nodeservClearListenRefs(void);
void ndoeservWriteListenRefFile(char *filename);
void nodeservWriteListenRef(void);

//int nodeservSubmitNode(NodeRef *nr, char *server, int port, char *email);
int nodeservSubmitNode(NodeRef *nr, char *page, char *server, int port);
int nodeservGetNodeRefs(char *page, char *server, int port);

int nodeservCheckNetworkNameVersion(char *netname, char * netversion);

#endif //NET_NODESERV_H

