#ifndef NET_SOCKSERV_H
#define NET_SOCKSERV_H

#include "net/sock.h"



typedef struct SockArrayHandle {
	int	size;
	SockHandle **data;
} SockArrayHandle;


extern SockArrayHandle *SocksListening;
extern SockArrayHandle *SocksOpen;


void sockservInit(void (*addfunc)(SockHandle *, int *));
void sockservPoll(void);

void sockservAddSock(SockArrayHandle *sah, SockHandle *sh);
void sockservAddOpen(SockHandle *sh);
void sockservAddListening(SockHandle *sh);

void sockservProcessOpen(void);
void sockservProcessListening(void);
void sockservProcess(void);

SockHandle *sockservConnect(void);
SockHandle *sockservListen(NodeRef *nr);
void sockservStartListen(void);


//internal functions
NodeRef *sockservPickNode(void);


#endif //NET_SOCKSERV_H
