//
//c-stream.c
//
//Interface for handling a crypto stream.
//
//
//-UserX 2002/06/03

#include "base/array.h"
#include "base/str.h"
#include "base/logger.h"
#include "c-stream.h"

CryptStreamProtocolEntry blankcryptstreamprotocolentry = BLANKCRYPTSTREAMPROTOCOLENTRY;
CryptStreamProtocolArrayHandle *csparray = NULL;

void csInit(void) {
	if(csparray == NULL) {
		csparray = (CryptStreamProtocolArrayHandle *)arrayMake(sizeof(CryptStreamProtocolEntry), 0, &blankcryptstreamprotocolentry, NULL, NULL);
	}
}

void csAddList(CryptStreamProtocolEntry *cspelist) {
	int i;
	int j;
	if(cspelist == NULL) {
		return;
	}
	csInit();
	for(i = 0; cspelist[i].csname != NULL; i++) {
		j = csparray->size;
		arrayInsert((ArrayHandle *)csparray, csparray->size, 1);
		csparray->data[j] = cspelist[i];
	}
}


CryptStream *csMake(char *csname, char *options) {
	int i;
	csInit();
	for(i = 0; i <= csparray->size; i++) {
		if(stringCaseCompare(csparray->data[i].csname, csname) == 0) {
			return (csparray->data[i].csmakefunc)(csname, options);
		}
	}
	LOGERROR(stringJoinMany("CryptStream type \"",
			csname,
			"\" not found.",
			NULL));
	return NULL;
}

void csFree(CryptStream *cs) {
	if(cs == NULL) {
		return;
	}
	noderefFree(cs->noderef);
	if(cs->FreeFunc == NULL) {
		return;
	}
	cs->FreeFunc(cs);
}

void csRead(CryptStream *cs) {
	if(cs == NULL) {
		return;
	}
	if(cs->ReadFunc == NULL) {
		return;
	}
	cs->ReadFunc(cs);
}

void csWrite(CryptStream *cs) {
	if(cs == NULL) {
		return;
	}
	if(cs->WriteFunc == NULL) {
		return;
	}
	cs->WriteFunc(cs);
}

