#ifndef PIPE_CRYPT_H
#define PIPE_CRYPT_H

#include "pipe/pipe.h"
#include "pipe/cs-iip1.h"

typedef struct PipeCrypt {
	Pipe	IOPipe;
	CryptStream *cryptstream;
} PipeCrypt;


#define BLANKPIPECRYPT {BLANKPIPE_PIPE, NULL}


Pipe *pipecryptMake(char *pipename, char *options);
void pipecryptFree(PipeCrypt *pc);
void pipecryptRead(PipeCrypt *thispipe, Pipe **errPipe);
void pipecryptWrite(PipeCrypt *thispipe, Pipe **errPipe);


void pipecryptRead(PipeCrypt *thispipe, Pipe **errPipe);
void pipecryptWrite(PipeCrypt *thispipe, Pipe **errPipe);
void pipecryptAttach(PipeCrypt *thispipe);
void pipecryptDetach(PipeCrypt *thispipe);
void pipecryptClose(PipeCrypt *thispipe);
void pipecryptStatus(PipeCrypt *thispipe, int *status);


#endif //PIPE_CRYPT_H
