#ifndef PIPE_MASQ_H
#define PIPE_MASQ_H

#include "net/sock.h"

typedef struct PipeMasq {
	Pipe	IOPipe;
	char	*protocol;
	SockHandle *sock;
	int	inwaiting;
} PipeMasq;

#define BLANKPIPEMASQ {BLANKPIPE_PIPE, NULL, NULL}


Pipe *pipemasqMake(char *protocol, char *options);
void pipemasqFree(PipeMasq *ps);
void pipemasqRead(PipeMasq *thispipe, Pipe **errPipe);
void pipemasqWrite(PipeMasq *thispipe, Pipe **errPipe);
void pipemasqAttach(PipeMasq *thispipe);
void pipemasqDetach(PipeMasq *thispipe);
void pipemasqClose(PipeMasq *thispipe);
void pipemasqStatus(PipeMasq *thispipe, int *status);

//internal functions
void pipemasqDoIO(PipeMasq *thispipe);

#endif //PIPE_MASQ_H
