%define version 0.2.5
Name:				rsync-backup
Summary:			rsync-backup provides an encrypted backup solution for Unices.
Version:			%{version}
Release:			0
Copyright:			GPL
Packager:			William Stearns <wstearns@pobox.com>
Source:				ftp://ftp.stearns.org/pub/rsync-backup/rsync-backup-%{version}.tar.gz
Buildarch:			noarch
Vendor:				William Stearns
URL:				http://www.pobox.com/~wstearns/
BuildRoot:			/tmp/rsync-backup-broot
Group:				Administration/Archiving

%package server
Summary:			The server portion of an encrypted backup solution for Unices.
Prereq:				/usr/bin/rsync-static
Group:				Administration/Archiving

%package client
Summary:			The client portion of an encrypted backup solution for Unices.
Prereq:				rsync
Group:				Administration/Archiving

%description
Rsync-backup provides an encrypted backup solution for Unices, including
Linux.

%description server
Rsync-backup provides an encrypted backup solution for Unices, including
Linux.

This package only needs to be installed on the server - the meachine that
will hold the backups.

%description client
Rsync-backup provides an encrypted backup solution for Unices, including
Linux.

This package needs to be installed on all machines you want backed up.

%changelog
* Thu Aug 15 2002 William Stearns <wstearns@pobox.com>
- maintenance is now split into daily and weekly

* Thu Mar 29 2001 William Stearns <wstearns@pobox.com>
- split into client and server

* Wed Mar 28 2001 William Stearns <wstearns@pobox.com>
- first release, generally functional


%prep
%setup
#%patch0 -p1 -b .make
#%patch1 -p1 -b .config


#%build
#make


%install
if [ "$RPM_BUILD_ROOT" = "/tmp/rsync-backup-broot" ]; then
	rm -rf $RPM_BUILD_ROOT

	install -d $RPM_BUILD_ROOT/backups
	install -d $RPM_BUILD_ROOT/etc/cron.daily
	install -d $RPM_BUILD_ROOT/etc/cron.weekly
	install -d $RPM_BUILD_ROOT/usr/bin
	install -d $RPM_BUILD_ROOT/usr/lib/rsync-backup
	install -d $RPM_BUILD_ROOT/usr/sbin
	make DESTDIR=$RPM_BUILD_ROOT install
	#cp -p goober.8 $RPM_BUILD_ROOT/usr/man/man8
	#cp -p $RPM_SOURCE_DIR/goober.init $RPM_BUILD_ROOT/etc/rc.d/init.d/goober
else
	echo Invalid Build root
	exit 1
fi

						
%clean
if [ "$RPM_BUILD_ROOT" = "/tmp/rsync-backup-broot" ]; then
	rm -rf $RPM_BUILD_ROOT
else
	echo Invalid Build root
	exit 1
fi


%files client
%defattr(-,root,root)
%attr(755,root,root)			/usr/bin/rsync-backup-client
%attr(644,root,root)			/usr/lib/rsync-backup/exclude.default
%attr(644,root,root)			/usr/lib/rsync-backup/localbackuponly.default
				%doc	COPYING CREDITS ChangeLog INSTALL Makefile NEWS README TODO

%files server
%defattr(-,root,root)
%attr(700,root,root)		%dir	/backups
%attr(755,root,root)			/etc/cron.daily/rsync-backup-daily-maintenance
%attr(755,root,root)			/etc/cron.weekly/rsync-backup-weekly-maintenance
%attr(755,root,root)			/usr/sbin/rsync-backup-server
				%doc	COPYING CREDITS ChangeLog INSTALL Makefile NEWS README TODO


#%attr(644,root,root)		%config	/etc/goober.conf
#%attr(644,root,root)			/usr/man/man8/goober.8


#%pre
#if [ "$1" = "1" ]; then		#This package is being installed for the first time
#    #pre - $1=1 - first install
#else				#This is an upgrade
#    #pre - $1=2 - upgrade (techically, $1>1)
#fi
#
#
#%post
#/sbin/chkconfig --add goober
#if [ "$1" = "1" ]; then         #This package is being installed for the first time
#	if [ -f /etc/rc.d/rc.sysinit ]; then
#		if [ `cat /etc/rc.d/rc.sysinit | grep devfsd | wc -l` -eq 0 ]; then	#If no references to devfs yet
#			#Add the following lines just after #!/bin/sh or #!/bin/bash.
#			cat /etc/rc.d/rc.sysinit | sed -e 's@\(#!/bin/.*sh\)@\1\
#if [ -c /dev/.devfsd ]; then                        #devfsdinstall\
#    if ! ps axf | grep [d]evfsd >/dev/null ; then   #devfsdinstall\
#        #devfs not running yet                      #devfsdinstall\
#        /sbin/devfsd /dev                           #devfsdinstall\
#    fi                                              #devfsdinstall\
#fi                                                  #devfsdinstall\
#@' >/etc/rc.d/rc.sysinit.tmp
#			cat /etc/rc.d/rc.sysinit.tmp >/etc/rc.d/rc.sysinit
#			rm -f /etc/rc.d/rc.sysinit.tmp
#		fi
#	else
#		echo You don\'t have an /etc/rc.d/rc.sysinit - you will need to add
#		echo 'if [ -c /dev/.devfsd ]; then'
#		echo '    if ! ps axf | grep [d]evfsd >/dev/null ; then'
#		echo '        /sbin/devfsd /dev'
#		echo '    fi'
#		echo 'fi'
#		echo to your initialization scripts, before any filesystem checking is done.
#	fi
#fi
#if [ "$1" = "1" ]; then		#This package is being installed for the first time
#    #post - $1=1 - first install
#else				#This is an upgrade
#    #post - $1=2 - upgrade (techically, $1>1)
#fi
#/usr/bin/at 04:00 <<EOTEXT
#/sbin/shutdown -r now
#EOTEXT
#
#
#%preun
#if [ "$1" = "0" ]; then		#This is being completely erased, not upgraded
#    #preun - $1=0 - final erasure
#else				#This is an upgrade
#    #preun - $1=1 - upgrade (techically, $1>0)
#fi
#
#
#%postun
#if [ "$1" = "0" ]; then         #Final removal, not upgrade.
#	if [ -f /etc/rc.d/rc.sysinit ]; then
#		if [ `cat /etc/rc.d/rc.sysinit | grep devfsdinstall | wc -l` -gt 0 ]; then
#			cat /etc/rc.d/rc.sysinit | grep -v devfsdinstall >/etc/rc.d/rc.sysinit.tmp
#			cat /etc/rc.d/rc.sysinit.tmp >/etc/rc.d/rc.sysinit
#			rm -f /etc/rc.d/rc.sysinit.tmp
#		fi
#	fi
#fi
#if [ $1 = 0 ] ; then
#	/sbin/chkconfig --del squid
#fi
#
#if [ "$1" = "0" ]; then		#This is being completely erased, not upgraded
#    #postun - $1=0 - final erasure
#else				#This is an upgrade
#    #postun - $1=1 - upgrade (techically, $1>0)
#fi
#		
##Here are the scripts run at first install, in this order:
##pre - 1 - first install
##post - 1 - first install
#
##Here are the scripts run during an upgrade, in this order:
##pre - 2 - upgrade
##post - 2 - upgrade
##preun - 1 - upgrade
##postun - 1 - upgrade
#
##Here are the scripts run at final erase, in this order:
##preun - 0 - final erasure
##postun - 0 - final erasure

